/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.utils;

import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.config.EnchantCalcConf;
import com.flemmli97.improvedmobs.config.EquipmentList;
import com.flemmli97.improvedmobs.difficulty.DifficultyData;
import com.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class GeneralHelperMethods {
    public static final UUID attMod = UUID.fromString("7c7e5c2d-1eb0-434a-858f-3ab81f52832c");

    public static boolean isMobInList(MobEntity living, List<? extends String> list, boolean reverse) {
        if (reverse) {
            return !GeneralHelperMethods.isMobInList(living, list, false);
        }
        for (String string : list) {
            ResourceLocation res = living.func_200600_R().getRegistryName();
            if (string.startsWith("@")) {
                return res != null && res.func_110624_b().equals(string.substring(1));
            }
            if (res == null || !res.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean canHarvest(BlockState block, ItemStack item) {
        return item.func_150998_b(block) || !block.func_235783_q_();
    }

    public static void equipArmor(MobEntity living) {
        if (Config.CommonConfig.baseEquipChance != 0.0f) {
            float difficulty = DifficultyData.getDifficulty(living.field_70170_p, (LivingEntity)living);
            float time = difficulty * Config.CommonConfig.diffEquipAdd * 0.01f;
            if (living.func_70681_au().nextFloat() < Config.CommonConfig.baseEquipChance + time) {
                for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                    ItemStack equip;
                    boolean shouldAdd;
                    if (slot.func_188453_a() == EquipmentSlotType.Group.HAND) continue;
                    boolean bl = shouldAdd = slot == EquipmentSlotType.HEAD || Config.CommonConfig.baseEquipChanceAdd != 0.0f && living.func_70681_au().nextFloat() < Config.CommonConfig.baseEquipChanceAdd + time;
                    if (!shouldAdd || !living.func_184582_a(slot).func_190926_b() || (equip = EquipmentList.getEquip(living, slot, difficulty)).func_190926_b()) continue;
                    if (!Config.CommonConfig.shouldDropEquip) {
                        living.func_184642_a(slot, 0.0f);
                    }
                    living.func_184201_a(slot, equip);
                }
            }
        }
    }

    public static void equipHeld(MobEntity living) {
        ItemStack stack;
        float difficulty = DifficultyData.getDifficulty(living.field_70170_p, (LivingEntity)living);
        float add = difficulty * Config.CommonConfig.diffWeaponChance * 0.01f;
        if (Config.CommonConfig.baseWeaponChance != 0.0f && living.func_70681_au().nextFloat() < Config.CommonConfig.baseWeaponChance + add && living.func_184614_ca().func_190926_b()) {
            stack = EquipmentList.getEquip(living, EquipmentSlotType.MAINHAND, difficulty);
            if (!Config.CommonConfig.shouldDropEquip) {
                living.func_184642_a(EquipmentSlotType.MAINHAND, -1.0f);
            }
            living.func_184201_a(EquipmentSlotType.MAINHAND, stack);
        }
        if (living instanceof AbstractPiglinEntity) {
            return;
        }
        add = DifficultyData.getDifficulty(living.field_70170_p, (LivingEntity)living) * Config.CommonConfig.diffItemChanceAdd * 0.01f;
        if (Config.CommonConfig.baseItemChance != 0.0f && living.func_70681_au().nextFloat() < Config.CommonConfig.baseItemChance + add && living.func_184592_cb().func_190926_b()) {
            stack = EquipmentList.getEquip(living, EquipmentSlotType.OFFHAND, difficulty);
            if (!Config.CommonConfig.shouldDropEquip) {
                living.func_184642_a(EquipmentSlotType.OFFHAND, 0.0f);
            }
            living.func_184201_a(EquipmentSlotType.OFFHAND, stack);
        }
    }

    public static void enchantGear(MobEntity living) {
        float diff = DifficultyData.getDifficulty(living.field_70170_p, (LivingEntity)living);
        EnchantCalcConf.Value val = Config.CommonConfig.enchantCalc.get(diff);
        if (val.max == 0) {
            return;
        }
        RandomValueRange rng = new RandomValueRange((float)val.min, (float)val.max);
        for (EquipmentSlotType entityequipmentslot : EquipmentSlotType.values()) {
            ItemStack itemstack = living.func_184582_a(entityequipmentslot);
            if (itemstack.func_77948_v() || itemstack.func_190926_b() || !(living.func_70681_au().nextFloat() < Config.CommonConfig.baseEnchantChance + diff * Config.CommonConfig.diffEnchantAdd * 0.01f)) continue;
            EnchantmentHelper.func_77504_a((Random)living.func_70681_au(), (ItemStack)itemstack, (int)rng.func_186511_a(living.func_70681_au()), (boolean)true);
        }
    }

    public static float getBreakSpeed(MobEntity entity, ItemStack stack, BlockState state) {
        float f = stack.func_150997_a(state);
        if (f > 1.0f) {
            int i = EnchantmentHelper.func_185293_e((LivingEntity)entity);
            ItemStack itemstack = entity.func_184614_ca();
            if (i > 0 && !itemstack.func_190926_b()) {
                f += (float)(i * i + 1);
            }
        }
        if (EffectUtils.func_205135_a((LivingEntity)entity)) {
            f *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)entity) + 1) * 0.2f;
        }
        if (entity.func_70644_a(Effects.field_76419_f)) {
            switch (entity.func_70660_b(Effects.field_76419_f).func_76458_c()) {
                case 0: {
                    f *= 0.3f;
                    break;
                }
                case 1: {
                    f *= 0.09f;
                    break;
                }
                case 2: {
                    f *= 0.0027f;
                    break;
                }
                default: {
                    f *= 8.1E-4f;
                }
            }
        }
        if (entity.func_208600_a((ITag)FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)entity)) {
            f /= 5.0f;
        }
        if (!entity.func_233570_aj_()) {
            f /= 5.0f;
        }
        return f;
    }

    public static float getBlockStrength(MobEntity entityLiving, BlockState state, World world, BlockPos pos) {
        float hardness = world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        ItemStack main = entityLiving.func_184614_ca();
        ItemStack off = entityLiving.func_184592_cb();
        if (GeneralHelperMethods.canHarvest(state, main)) {
            float offSpeed;
            float speed = GeneralHelperMethods.getBreakSpeed(entityLiving, main, state);
            if (GeneralHelperMethods.canHarvest(state, off) && (offSpeed = GeneralHelperMethods.getBreakSpeed(entityLiving, off, state)) > speed) {
                speed = offSpeed;
            }
            return speed / hardness / 30.0f;
        }
        if (GeneralHelperMethods.canHarvest(state, off)) {
            return GeneralHelperMethods.getBreakSpeed(entityLiving, off, state) / hardness / 30.0f;
        }
        return GeneralHelperMethods.getBreakSpeed(entityLiving, main, state) / hardness / 100.0f;
    }

    public static void modifyAttr(MobEntity living, Attribute att, double value, double max, float difficulty, boolean multiply) {
        ModifiableAttributeInstance inst = living.func_110148_a(att);
        if (inst == null || inst.func_111127_a(attMod) != null) {
            return;
        }
        double oldValue = inst.func_111125_b();
        value *= (double)difficulty;
        if (multiply) {
            value = max <= 0.0 ? value : Math.min(value, max - 1.0);
            value = oldValue * value;
            if (att == Attributes.field_233818_a_) {
                value = Config.CommonConfig.roundHP > 0.0 ? MathUtils.roundTo((double)value, (double)Config.CommonConfig.roundHP) : value;
            }
        } else {
            value = max <= 0.0 ? value : Math.min(value, max);
        }
        inst.func_233769_c_(new AttributeModifier(attMod, "im_modifier", value, AttributeModifier.Operation.ADDITION));
    }
}

